﻿namespace Microsoft.Samples.PlanMyNight.Web.Controllers
{
    using System.Web.Mvc;
    using Microsoft.Samples.PlanMyNight.Infrastructure;

    public class SiteMasterController : Controller
    {
        private readonly IMembershipService membershipService;

        public SiteMasterController() :
            this(new ServiceFactory().GetMembershipService())
        {
        }

        public SiteMasterController(IMembershipService membershipService)
        {
            this.membershipService = membershipService;
        }

        public PartialViewResult LoginStatus()
        {
            var model = this.membershipService.GetCurrentProfile();
            if (string.IsNullOrEmpty(model.FullName)) model.FullName = "Anonymous";
            return PartialView("LogOn", model);
        }

        public ViewResult Error(string aspxerrorpath)
        {
            HandleErrorInfo model = null;
            var exception = HttpContext.Server.GetLastError();
            if (exception != null)
            {
                model = new HandleErrorInfo(exception, "(null)", "(null)");
            }

            return View("Error", model);
        }
    }
}
